unit uTestCaseException;

{
  This code copied from the TestException example that came with DUnit
  It overrides RunTest to give an error if the expected exception doesn't occur
}

interface

uses
  TestFramework
  , sysutils                        // for definition of Exception
  ;

type
  ExceptionClass = class of Exception;

  TTestCaseException = class(TTestCase)
  private
    FExpectedException: ExceptionClass;
  public
    procedure SetExpectedException(Value :ExceptionClass);
    procedure RunTest; override;
  end;

implementation

{ TTestCaseException }

procedure TTestCaseException.RunTest;
begin
  try
    inherited runTest;
    if FExpectedException <> nil then
      fail('Excepted Exception did not occur');
  except
     on E: Exception do
     begin
       if FExpectedException = nil then
         raise
       else
         if E.ClassType <> FExpectedException then
           raise;
     end;
  end;
  { clear the exception until the next test registers an Exception }
  FExpectedException := nil;
end;

procedure TTestCaseException.SetExpectedException(
  Value: ExceptionClass);
begin
  FExpectedException := Value
end;

end.
