unit uSingletonFunctionTest;

interface

uses
  TestFramework
  , uTestCaseException
  , SingletonFunction
  ;

type

  TSingletonFunctionTest = class(TTestCaseException)
  private

  published
    procedure TestNotNil;
    procedure TestCreateError;
    procedure TestFreeError;
  end;

implementation

{ TSingletonFunctionTest }

procedure TSingletonFunctionTest.TestCreateError;
var
  sfTmp: TSingleton;
begin
  // See what happens when we call the Create method
  Self.SetExpectedException(ESingleton);
  sfTmp := nil;
  sfTmp := TSingleton.Create;
  // Ideally, we don't want anything to happen
  Check(not Assigned(sfTmp), 'Singleton was assigned by calling Create');
end;

procedure TSingletonFunctionTest.TestFreeError;
var
  sfTmp: TSingleton;
  nTmp: integer;
begin
  // See what happens when we call the singleton's free method
  Self.SetExpectedException(ESingleton);
  sfTmp := nil;
  // Get a reference to the singleton
  sfTmp := Singleton;
  Check(Assigned(sfTmp), 'Singleton not assigned (1st time)');
  // Now call the free method
  sfTmp.Free;
  sfTmp := nil;
  // Now try getting another reference
  sfTmp := Singleton;
  // If we get this far, make sure we've got a valid reference
  Check(Assigned(sfTmp), 'Singleton not assigned (2nd time)');
  // Try to call the object's Create method
  sfTmp.Create;
end;

procedure TSingletonFunctionTest.TestNotNil;
var
  sfTmp: TSingleton;
begin
  // We should be able to get the singleton from the function
  sfTmp := nil;
  sfTmp := Singleton;
  Check(Assigned(sfTmp), 'SingletonFunction not assigned');
end;

initialization
  TestFramework.RegisterTest(TSingletonFunctionTest.Suite);

end.
