unit uSimpleSingleton3;

interface

uses
  sysutils            // for definition of Exception
  ;

type
  ESimpleSingleton3 = class(Exception);

  TSimpleSingleton3 = class
  private

    FInitialised: boolean;
    FInitCount: integer;          // for testing purposes
    FValue: integer;              // for testing purposes

//    destructor DestroyInstance;

    procedure Initialise;

  public

    constructor Create;
    destructor Destroy; override;
    // DestroyInstance would normally be private, but I've made it public here
    // so I can destroy the Singleton in the test suite
    destructor DestroyInstance;

    procedure FreeInstance; override;
    class function NewInstance: TObject; override;

    property Value: integer         // for testing purposes
      read FValue
      write FValue;

    property InitCount: integer     // for testing purposes
      read FInitCount;

  end;

implementation

uses
  Dialogs             // for ShowMessage
  ;

var
  gSimpleSingleton3: TSimpleSingleton3 = nil;

{ TSimpleSingleton3 }

constructor TSimpleSingleton3.Create;
begin
  if not FInitialised then
  begin
    Initialise;
  end;
  FInitialised := True;
end;

destructor TSimpleSingleton3.Destroy;
begin
  Abort;
end;

destructor TSimpleSingleton3.DestroyInstance;
begin
  inherited Destroy;
end;

procedure TSimpleSingleton3.FreeInstance;
begin
{// Uncomment this to see when FreeInstance is called
  ShowMessage('TSimpleSingleton3.FreeInstance');}
  if Assigned(gSimpleSingleton3) then
  begin
    inherited;
    // Set the unit variable to nil, in case we need it again
    gSimpleSingleton3 := nil;
  end;
end;

procedure TSimpleSingleton3.Initialise;
begin
  // do initialisation here

  // Keep track of how many times we've called the Create code, so we can test it
  Inc(FInitCount);
end;

class function TSimpleSingleton3.NewInstance: TObject;
begin
{// Uncomment this to see when NewInstance is called
  ShowMessage('TSimpleSingleton3.NewInstance');}
  // If we've already created the singleton, return it, otherwise create a new one
  if Assigned(gSimpleSingleton3) then
  begin
    // Singleton already created - return it
    Result := gSimpleSingleton3;
  end
  else
  begin
    // Singleton not created yet - create and return it
    // Get memory for the new object instance
    GetMem(Pointer(gSimpleSingleton3), Self.InstanceSize);
    // Initialise the object's memory block to all zeroes
    Result := InitInstance(gSimpleSingleton3);
  end;
end;

initialization
// Dummy initialization, so we can have a finalization

finalization
  if Assigned(gSimpleSingleton3) then
    gSimpleSingleton3.DestroyInstance;

end.
