unit uSimpleSingleton2;

interface

uses
  sysutils            // for definition of Exception
  ;

type
  ESimpleSingleton2 = class(Exception);

  TSimpleSingleton2 = class
  private

    FValue: integer;

    constructor CreateInstance;
    destructor DestroyInstance;

  public

    constructor Create; virtual;
    destructor Destroy; override;

{// Uncomment this to see when FreeInstance is called
    procedure FreeInstance; override;}

    property Value: integer
      read FValue
      write FValue;

  end;

function SimpleSingleton2: TSimpleSingleton2;

implementation

uses
  Dialogs             // for ShowMessage
  ;

var
  gSimpleSingleton2: TSimpleSingleton2 = nil;

function SimpleSingleton2: TSimpleSingleton2;
begin
  if not Assigned(gSimpleSingleton2) then
  begin
    gSimpleSingleton2 := TSimpleSingleton2.CreateInstance;
  end;
  Result := gSimpleSingleton2;
end;

{ TSimpleSingleton2 }

constructor TSimpleSingleton2.Create;
begin
  raise ESimpleSingleton2.Create('You may not create another Singleton object.' +
                                ' Please use ''SimpleSingleton2''.');
end;

constructor TSimpleSingleton2.CreateInstance;
begin
  inherited Create;
end;

destructor TSimpleSingleton2.Destroy;
begin
  raise ESimpleSingleton2.Create('You may not destroy the Singleton object.');
end;

destructor TSimpleSingleton2.DestroyInstance;
begin
  inherited Destroy;
end;

{// Uncomment this to see when FreeInstance is called
procedure TSimpleSingleton2.FreeInstance;
begin
  ShowMessage('TSimpleSingleton2.FreeInstance');
  inherited;
end;}

initialization
// Dummy initialization, so we can have a finalization

finalization
  if Assigned(gSimpleSingleton2) then
    gSimpleSingleton2.DestroyInstance;

end.
