unit uSimpleSingleton;

interface

type
  TSimpleSingleton = class
  private

    FValue: integer;

  public

    property Value: integer
      read FValue
      write FValue;

  end;

function SimpleSingleton: TSimpleSingleton;

implementation

var
  gSimpleSingleton: TSimpleSingleton = nil;

function SimpleSingleton: TSimpleSingleton;
begin
  if not Assigned(gSimpleSingleton) then
  begin
    gSimpleSingleton := TSimpleSingleton.Create;
  end;
  Result := gSimpleSingleton;
end;

initialization
// Dummy initialization, so we can have a finalization

finalization
  if Assigned(gSimpleSingleton) then
    gSimpleSingleton.Free;

end.
