{***************************************************************
 *
 * Unit Name: SingletonFunction
 * Purpose  : Example of a singleton via a unit function
 * Author   : Rob Bracken for uk-bug developer's magazine 3rd May 2002
 * History  :
 *
 * You are free to use this in your own projects
 *
 * Notes:
 *
 * 1. If you call Create or Destroy, you'll get an ESingleton error. Always use
 *    the "Singleton" function to get a reference to the singleton object.
 * 2. Copy this unit to your project and add methods & properties as required.
 *
 ****************************************************************}

unit SingletonFunction;

interface

uses
  sysutils                    // for definition of Exception
  ;

type
  ESingleton = class(Exception);

  TSingleton = class
  private

    constructor CreateInstance;
    destructor DestroyInstance;

  public

    constructor Create; virtual;
    destructor Destroy; override;

  end;

function Singleton: TSingleton;

implementation

var
  gSingleton: TSingleton = nil;

function Singleton: TSingleton;
begin
  if not Assigned(gSingleton) then
  begin
    gSingleton := TSingleton.CreateInstance;
  end;
  Result := gSingleton;
end;

{ TSingleton }

constructor TSingleton.Create;
begin
  raise ESingleton.Create('You may not create another Singleton object.' +
                                ' Please use ''Singleton''.');
end;

constructor TSingleton.CreateInstance;
begin
  inherited Create;
end;

destructor TSingleton.Destroy;
begin
  raise ESingleton.Create('You may not destroy the Singleton object.');
end;

destructor TSingleton.DestroyInstance;
begin
  inherited Destroy;
end;

initialization
// Dummy initialization, so we can have a finalization

finalization
  if Assigned(gSingleton) then
    gSingleton.DestroyInstance;

end.
