unit uMessSender;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, uMessageCommons;

type
  TForm1 = class(TForm)
    imPicture: TImage;
    edInteger: TEdit;
    mmText: TMemo;
    btnSendImage: TButton;
    btnSendInteger: TButton;
    btnSendString: TButton;
    OpenDialog1: TOpenDialog;
    procedure btnSendIntegerClick(Sender: TObject);
    procedure imPictureClick(Sender: TObject);
    procedure btnSendStringClick(Sender: TObject);
    procedure btnSendImageClick(Sender: TObject);
  private
    { Private declarations }
    procedure SendData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.imPictureClick(Sender: TObject);
begin
   if OpenDialog1.Execute then
      imPicture.Picture.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.SendData(aData: TMemoryStream);
var
   _handle: THandle;
   _len: dword;
begin
   { open the mailslot }
   _handle:= CreateFile('\\CrisLaptop\mailslot\testslot', GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);
   { check for errors }
   if (_handle = INVALID_HANDLE_VALUE) then
      raise Exception.Create('failed to open the mailslot ' + SysErrorMessage(GetLastError));
   try
      { write the data and check the success }
      if not WriteFile(_handle, aData.memory^, aData.Size, _len, nil) or (_len <> aData.Size) then
         raise Exception.Create('failed to send data');
   finally
      { close the mailslot }
      CloseHandle(_handle);
   end;
end;

procedure TForm1.btnSendIntegerClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtInteger);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _int:= StrToIntDef(edInteger.Text, 0);
      _msg.Write(_int, SizeOf(integer));
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendStringClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
   _ln: integer;
   _str: string;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtString);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _str:= mmText.Text;
      _ln:= length(_str);
      if (_ln > 0) then
         _msg.Write(_str[1], _ln);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendImageClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtImage);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      imPicture.Picture.Bitmap.SaveToStream(_msg);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

end.
