unit uMessReceiver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uMessageCommons;

type
  TfrmMessageReceiver = class(TForm)
    mmText: TMemo;
    imPicture: TImage;
    edInteger: TEdit;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FSlot: THandle;
    procedure ReceiveData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  frmMessageReceiver: TfrmMessageReceiver;

implementation

{$R *.DFM}

{ TfrmMessageReceiver }

procedure TfrmMessageReceiver.ReceiveData(aData: TMemoryStream);
var
  _int: integer;
  _str: string;
  _ln: integer;
begin
   { read the data type }
   aData.Read(_int, SizeOf(integer));

   case TMessageType(_int) of

      mtInteger:
         begin
            { read an integer }
            aData.Read(_int, SizeOf(integer));
            { display it }
            edInteger.Text:= IntToStr(_int);
         end;

      mtString:
         begin
            { calculate the string length }
            _ln:= aData.Size - SizeOf(integer); 
            SetLength(_str, _ln);
            { read the string }
            if (_ln > 0) then
               aData.Read(_str[1], _ln);
            { display it }
            mmText.Text:= _str;
         end;

      mtImage:
         begin
            { load and display the bitmap }
            imPicture.Picture.Bitmap.LoadFromStream(aData);
         end;
   end;
end;

procedure TfrmMessageReceiver.Timer1Timer(Sender: TObject);
var
   _NextSize: dword;
   _s: string;
   _len: dword;
   _ms: TMemoryStream;
begin
   { query the mailsot for data available }
   if not GetMailSlotInfo(FSlot,NIL, _NextSize, nil, NIL) then
      raise Exception.Create('failed to query the mailslot ' + SysErrorMessage(GetLastError));
   { check if any data }
   if (_NextSize <> MAILSLOT_NO_MESSAGE) then
      begin
         { get some buffer }
         SetLength(_s, _NextSize);
         { read and check for success }
         if (not ReadFile(FSlot, _s[1], _NextSize, _len, NIL)) or (_len <> _NextSize) then 
            raise Exception.Create('failed to read the mailslot ' + SysErrorMessage(GetLastError));
         { create the memory stream }
         _ms:= TMemoryStream.Create;
         try
            { write the msg data }
            _ms.Write(_s[1], _NextSize);
            { go to begining of the file }
            _ms.Position:= 0;
            { decode the stream }
            ReceiveData(_ms);
         finally
            _ms.Free;
         end;
      end;
end;

procedure TfrmMessageReceiver.FormCreate(Sender: TObject);
begin
   { create the mailslot }
   FSlot:= CreateMailSlot('\\.\mailslot\testslot', 0, MAILSLOT_WAIT_FOREVER, NIL);
   { check for errors }
   if (FSlot = INVALID_HANDLE_VALUE) then
      raise Exception.Create('failed to open the mailslot ' + SysErrorMessage(GetLastError));
end;

procedure TfrmMessageReceiver.FormDestroy(Sender: TObject);
begin
   { close the mailslot }
   CloseHandle(FSlot);
end;

end.
