unit uMessReceiver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uMessageCommons;

type
  TfrmMessageReceiver = class(TForm)
    mmText: TMemo;
    imPicture: TImage;
    edInteger: TEdit;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
    procedure ReceiveData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  frmMessageReceiver: TfrmMessageReceiver;

implementation

{$R *.DFM}

{ TfrmMessageReceiver }

procedure TfrmMessageReceiver.ReceiveData(aData: TMemoryStream);
var
  _int: integer;
  _str: string;
  _ln: integer;
begin
   { read the data type }
   aData.Read(_int, SizeOf(integer));

   case TMessageType(_int) of

      mtInteger:
         begin
            { read an integer }
            aData.Read(_int, SizeOf(integer));
            { display it }
            edInteger.Text:= IntToStr(_int);
         end;

      mtString:
         begin
            { calculate the string length }
            _ln:= aData.Size - SizeOf(integer); 
            SetLength(_str, _ln);
            { read the string }
            if (_ln > 0) then
               aData.Read(_str[1], _ln);
            { display it }
            mmText.Text:= _str;
         end;

      mtImage:
         begin
            { load and display the bitmap }
            imPicture.Picture.Bitmap.LoadFromStream(aData);
         end;
   end;
end;

procedure TfrmMessageReceiver.Timer1Timer(Sender: TObject);
begin
   { todo check if any data available }
end;

end.
