unit uMessSender;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, uMessageCommons, clipbrd;

type
  TForm1 = class(TForm)
    imPicture: TImage;
    edInteger: TEdit;
    mmText: TMemo;
    btnSendImage: TButton;
    btnSendInteger: TButton;
    btnSendString: TButton;
    OpenDialog1: TOpenDialog;
    procedure btnSendIntegerClick(Sender: TObject);
    procedure imPictureClick(Sender: TObject);
    procedure btnSendStringClick(Sender: TObject);
    procedure btnSendImageClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure SendData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  CF_DATA: integer;

implementation

{$R *.DFM}

procedure TForm1.imPictureClick(Sender: TObject);
begin
   if OpenDialog1.Execute then
      imPicture.Picture.LoadFromFile(OpenDialog1.FileName);
end;

procedure TForm1.SendData(aData: TMemoryStream);
var
   _hmem: cardinal;
   _p: pointer;
begin
   _hmem:= GlobalAlloc(GMEM_MOVEABLE or GMEM_DDESHARE, aData.Size);
   _p:= GlobalLock(_hmem);
   try
      Move(aData.memory^, _p^, aData.Size);
   finally
      GlobalUnlock(_hmem);
   end;
   Clipboard.SetAsHandle(CF_DATA, _hmem);
end;

procedure TForm1.btnSendIntegerClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtInteger);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _int:= StrToIntDef(edInteger.Text, 0);
      _msg.Write(_int, SizeOf(integer));
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendStringClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
   _ln: integer;
   _str: string;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtString);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      _str:= mmText.Text;
      _ln:= length(_str);
      if (_ln > 0) then
         _msg.Write(_str[1], _ln);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.btnSendImageClick(Sender: TObject);
var
   _msg: TMemoryStream;
   _int: integer;
begin
   _msg:= TMemoryStream.Create;
   try
      { write data type }
      _int:= ord(mtImage);
      _msg.Write(_int, SizeOf(integer));
      { write data }
      imPicture.Picture.Bitmap.SaveToStream(_msg);
      { send the message }
      SendData(_msg);
   finally
      _msg.Free;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   CF_DATA:= RegisterClipboardFormat('Test Clipboard');
end;

end.
