unit uMessReceiver;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, uMessageCommons, clipbrd;

type
  TfrmMessageReceiver = class(TForm)
    mmText: TMemo;
    imPicture: TImage;
    edInteger: TEdit;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure ReceiveData(aData: TMemoryStream);
  public
    { Public declarations }
  end;

var
  frmMessageReceiver: TfrmMessageReceiver;
  CF_DATA: integer;

implementation

uses Math;

{$R *.DFM}

{ TfrmMessageReceiver }

procedure TfrmMessageReceiver.ReceiveData(aData: TMemoryStream);
var
  _int: integer;
  _str: string;
  _ln: integer;
begin
   { read the data type }
   aData.Read(_int, SizeOf(integer));

   case TMessageType(_int) of

      mtInteger:
         begin
            { read an integer }
            aData.Read(_int, SizeOf(integer));
            { display it }
            edInteger.Text:= IntToStr(_int);
         end;

      mtString:
         begin
            { calculate the string length }
            _ln:= aData.Size - SizeOf(integer); 
            SetLength(_str, _ln);
            { read the string }
            if (_ln > 0) then
               aData.Read(_str[1], _ln);
            { display it }
            mmText.Text:= _str;
         end;

      mtImage:
         begin
            { load and display the bitmap }
            imPicture.Picture.Bitmap.LoadFromStream(aData);
         end;
   end;
end;

procedure TfrmMessageReceiver.Timer1Timer(Sender: TObject);
var
   _hmem: cardinal;
   _p: pointer;
   _ms: TMemoryStream;
begin
   { check if any data available }
   if Clipboard.HasFormat(CF_DATA) then
      begin
         _hmem:= Clipboard.GetAsHandle(CF_DATA);
         if (GlobalSize(_hmem) > 0) then
            begin
               _p:= GlobalLock(_hmem);
               try
                  { create a stream }
                  _ms:= TMemoryStream.Create;
                  try
                     { write the msg data }
                     _ms.Write(_p^, GlobalSize(_hmem));
                     { go to begining of the file }
                     _ms.Position:= 0;
                     { decode the stream }
                     ReceiveData(_ms);
                  finally
                     _ms.Free;
                  end;
               finally
                  GlobalUnlock(_hmem);
               end;
            end;
      end;
end;

procedure TfrmMessageReceiver.FormCreate(Sender: TObject);
begin
   CF_DATA:= RegisterClipboardFormat('Test Clipboard');
end;

end.
