using Android.Content;

//Class that surfaces shared preferences in a given file name.
//Updates to the shared preferences are batched by a shared preferences editor

namespace TimeSheet
{
    class TimeSheetPreferences 
    {
        private ISharedPreferences prefs = null;
        private ISharedPreferencesEditor editor = null;
        private int userID;
        private string userName;
        private string userEmail;
        private string userPassword;
        private const string userIDKey = "UserID";
        private const string userPasswordKey = "UserPassword";
        private const string userEmailKey = "UserEmail";
        private const string userNameKey = "UserName";
        private const string prefsFileName = "Time_Sheet_Prefs";

        public TimeSheetPreferences(Context context)
        {
            prefs = context.GetSharedPreferences(prefsFileName, FileCreationMode.Private);
            editor = prefs.Edit();
        }

        public string GetValue(string Key, string DefaultValue)
        {
            if (prefs == null)
                return Consts.NA;
            return prefs.GetString(Key, DefaultValue);
        }

        public void SetValue(string Key, string Value)
        {
            if (editor == null)
                return;
            editor.PutString(Key, Value);
        }

        public void SetValue(string Key, int Value)
        {
            if (editor == null)
                return;
            editor.PutInt(Key, Value);
        }

        public int UserID
        {
            get
            {
                if (prefs == null)
                    return -1;
                userID = prefs.GetInt(userIDKey, -1);
                return userID;
            }
            set
            {
                SetValue(userIDKey, value);
            }
        }

        public string UserPassword
        {
            get
            {
                if (prefs == null)
                    return Consts.NA;
                userPassword = prefs.GetString(userPasswordKey, Consts.NA);
                return userPassword;
            }
            set
            {
                SetValue(userPasswordKey, value);
            }
        }

        public string UserEmail
        {
            get
            {
                if (prefs == null)
                    return Consts.NA;
                userEmail = prefs.GetString(userEmailKey, Consts.NA);
                return userEmail;
            }
            set
            {
                SetValue(userEmailKey, value);
            }
        }

        public string UserName
        {
            get
            {
                if (prefs == null)
                    return Consts.NA;
                userName = prefs.GetString(userNameKey, Consts.NA);
                return userName;
            }
            set
            {
                SetValue(userNameKey, value);
            }
        }

        public void Save()
        {
            if (editor == null)
                return;
            editor.Commit();
        }
    }
}