using System;

using Android.App;
using Android.Content;

//Global object that allows access to a single database helper instance

namespace TimeSheet
{
    [Application]
    class TimeSheetApplication: Application
    {
        private DBHelper dbHelper;

        public TimeSheetApplication(IntPtr i) : base(i) 
        {
            dbHelper = new DBHelper(ApplicationContext);
        }

        public override void OnCreate()
        {
            base.OnCreate();
            AppContext = ApplicationContext;
        }

        public static Context AppContext
        {
            get ; private set ;
        }

        public DBHelper DatabaseHelper
        {
            get
            {
                return dbHelper;
            }
        }
    }
}