using Android.App;
using Android.Content;
using Android.OS;
using Android.Views;

using Java.Lang;

namespace TimeSheet
{
    [Activity(Label = "@string/ApplicationName", Theme = "@android:style/Theme.Translucent", MainLauncher = true)]
    public class SplashActivity : Activity
    {
        private Handler handler;
        private SplashScreenRunner runner;
        private const int splashDuration = 2000;

        protected override void OnCreate(Bundle bundle)
        {
            base.OnCreate(bundle);
            //Make the UI behind us all blurry
            Window.SetFlags(Android.Views.WindowManagerFlags.BlurBehind, Android.Views.WindowManagerFlags.BlurBehind);
            //Load UI
            SetContentView(Resource.Layout.SplashLayout);
        }

        protected override void OnStart()
        {
            base.OnStart();
            handler = new Handler();
            runner = new SplashScreenRunner(this);
            handler.PostDelayed(runner, splashDuration);
        }

        public override bool OnTouchEvent(MotionEvent e)
        {
            if (e.Action == MotionEventActions.Up)
            {
                handler.RemoveCallbacks(runner);
                handler.Post(runner);
            }
            return true;
        }

        private class SplashScreenRunner : Java.Lang.Object, IRunnable
        {
            private Activity context;

            public SplashScreenRunner(Activity ctx)
                : base()
            {
                this.context = ctx;
            }

            public void Run()
            {
			    context.StartActivity(new Intent(context, typeof(MainActivity)));
			    context.Finish();
            }
        }
    }
}