using Android.App;
using Android.OS;
using Android.Views;
using Android.Widget;

using Android.Database;
using Android.Util;

namespace TimeSheet
{
    [Activity(Label = "@string/ReportTitle")]
    public class ReportActivity : ListActivity, SimpleCursorAdapter.IViewBinder
    {
        private TimeSheetPreferences prefs;
        
        protected override void OnCreate(Bundle bundle)
        {
            base.OnCreate(bundle);
            //No main layout to load
            try
            {
                prefs = new TimeSheetPreferences(ApplicationContext);
                var fieldsFrom = new string[] { "desc", "comment", "synced" };
                var fieldsTo = new int[] { Android.Resource.Id.Text1, Android.Resource.Id.Text2, Resource.Id.ReportItemImage };
                Log.Info(Consts.Tag, "Generating a report for user " + prefs.UserID.ToString());
                var cursor = ((TimeSheetApplication)Application).DatabaseHelper.GenerateReportList(prefs.UserID);
                StartManagingCursor(cursor);
                var reportHeader = LayoutInflater.Inflate(Resource.Layout.ReportHeaderLayout, null);
                var reportHeaderText = reportHeader.FindViewById<TextView>(Android.Resource.Id.Text1);
                reportHeaderText.Text = string.Format("{0}\n{1}", prefs.UserName, prefs.UserEmail);
                ListView.AddHeaderView(reportHeader);
                ListView.SetHeaderDividersEnabled(true);
                var adapter = new SimpleCursorAdapter(this, Resource.Layout.ReportItemLayout, cursor, fieldsFrom, fieldsTo);
                //One of the fields is a Boolean and is represented by one of two images. The SimpleCursorAdapter
                //can't handle that by default, so we implement SimpleCursorAdapter.IViewBinder in this Activity and its 
                //SetViewValue() method caters for it
                adapter.ViewBinder = this;
                ListAdapter = adapter;
            }
            catch (Java.Lang.Throwable t)
            {
                Common.LogException(t);
                throw t;
            }
        }

        //Used to customise the SimpleCursor Adapter
        public bool SetViewValue(View view, ICursor cursor, int columnIndex)
        {
            switch (columnIndex)
            {
                case 2:
                    //For the Boolean column, choose an image view resource based on the value
                    bool synced = cursor.GetInt(columnIndex) != 0;
                    ((ImageView)view).SetImageResource(
                        synced ? Android.Resource.Drawable.StarBigOn : Android.Resource.Drawable.StarBigOff);
                    return true;
                default:
                    //Let the adapter do its normal business with the other column bindings
                    return false;
            }
        }
    }
}