using System;

using Android.App;
using Android.OS;
using Android.Widget;

using System.Threading;
using Android.Util;

namespace TimeSheet
{
    [Activity(Label = "@string/LoginTitle", Theme = "@android:style/Theme.Dialog")]
    public class LoginActivity : Activity
    {
        private EditText userEmailEditText;
        private EditText passwordEditText;
        private Button loginButton;
        private TimeSheetPreferences prefs;
        private ProgressDialog progressDialog;

        protected override void OnCreate(Bundle bundle)
        {
            base.OnCreate(bundle);
            prefs = new TimeSheetPreferences(ApplicationContext);
            SetContentView(Resource.Layout.LoginLayout);
            userEmailEditText = FindViewById<EditText>(Resource.Id.LoginUserEmailEditText);
            passwordEditText = FindViewById<EditText>(Resource.Id.LoginPasswordEditText);
            if (prefs.UserEmail != Consts.NA)
                userEmailEditText.Text = prefs.UserEmail;
#if DEBUG
            else
            {
                userEmailEditText.Text = "brian@blong.com";
                passwordEditText.Text = "password";
            }
#endif
            loginButton = FindViewById<Button>(Resource.Id.LoginButton);
            loginButton.Click += new EventHandler(loginButton_Click);
        }

        public override void OnBackPressed()
        {
            //If the preferences indicate no login, there is no point going back to main, 
            //else we'll come straight back to this activity again
            if (prefs.UserName == Consts.NA)
                //Set result code for the return to main activity
                SetResult(Result.Canceled);
            base.OnBackPressed();
        }

        void loginButton_Click(object sender, EventArgs e)
        {
            if ((userEmailEditText.Text.Trim() == "") || (passwordEditText.Text.Trim() == ""))
            {
                Common.LongToast(Resource.String.LoginValueIsBlank);
                return;
            }
            progressDialog = ProgressDialog.Show(this, GetString(Resource.String.LoginProgressTitle), 
                GetString(Resource.String.LoginProgressMessage), true, false);
            ThreadPool.QueueUserWorkItem((o) => DoLogin());
        }

        private void DoLogin()
        {
            string loginXml = Common.CallWebServiceToLoginAndGetUserData(
                this, userEmailEditText.Text, passwordEditText.Text) ?? "";
            if (loginXml != "")
            {
                try
                {
                    Log.Info(Consts.Tag, "Processing user data after login");
                    Common.ProcessUserData(this, loginXml, true, userEmailEditText.Text, passwordEditText.Text);
                }
                catch (Java.Lang.Throwable t)
                {
                    Common.LogException(t);
                    RunOnUiThread(() => Common.ShortToast(t.Message));
                }
                catch (Exception e)
                {
                    Log.Error(Consts.Tag, "Exception caught: " + e.Message);
                    RunOnUiThread(() => Common.ShortToast(e.Message));
                }
                //If we got to this point, then all went well, so we are logged in and can go back to the main activity
                RunOnUiThread(() => Common.ShortToast(Resource.String.LoginSuccessfulLogin));                 
                SetResult(Result.Ok);
                Finish();
            }
            else
                RunOnUiThread(() => Common.LongToast(Resource.String.LoginFailedLogin));
            RunOnUiThread (() => progressDialog.Dismiss());
        }
    }
}