using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Widget;
using System.Xml;

using Android.Util;
using System.IO;
using Java.IO;
using Android.Runtime;
using Android.Content;
using System.Globalization;

namespace TimeSheet
{
    class Common
    {
        #region Toast routines
        public static void LongToast(string msg)
        {
            Toast.MakeText(TimeSheetApplication.AppContext, msg, ToastLength.Long).Show();
        }

        public static void LongToast(string fmt, params object[] args)
        {
            LongToast(string.Format(fmt, args));
        }

        public static void LongToast(int resId)
        {
            Toast.MakeText(TimeSheetApplication.AppContext, resId, ToastLength.Long).Show();
        }

        public static void ShortToast(string msg)
        {
            Toast.MakeText(TimeSheetApplication.AppContext, msg, ToastLength.Short).Show();
        }

        public static void ShortToast(string fmt, params object[] args)
        {
            ShortToast(string.Format(fmt, args));
        }

        public static void ShortToast(int resId)
        {
            Toast.MakeText(TimeSheetApplication.AppContext, resId, ToastLength.Short).Show();
        }
        #endregion

        #region XML node value retrieval routines
        public static string XMLNodeString(XmlNode node, string name)
        {
            XmlNode child;
            child = node[name];
            if (child != null)
                return child.InnerText;
            return null;
        }

        public static int XMLNodeInteger(XmlNode node, string name)
        {
            XmlNode child;
            child = node[name];
            if (child != null)
                return Convert.ToInt32(child.InnerText);
            throw new ArgumentException("No integer value in the supplied XML node");
        }

        public static double XMLNodeDouble(XmlNode node, string name)
        {
            XmlNode child;
            child = node[name];
            if (child != null)
                return Convert.ToDouble(child.InnerText);
            throw new ArgumentException("No double value in the supplied XML node");
        }

        public static DateTime XMLNodeDateTime(XmlNode node, string name)
        {
            XmlNode child;
            child = node[name];
            if (child != null)
                return DateTime.ParseExact(child.InnerText, Consts.DateTimeFmtXML, CultureInfo.InvariantCulture);
            throw new ArgumentException("No DateTime value in the supplied XML node");
        }

        public static bool XMLNodeBoolean(XmlNode node, string name)
        {
            XmlNode child;
            child = node[name];
            if (child != null)
                return Convert.ToBoolean(child.InnerText);
            throw new ArgumentException("No Boolean value in the supplied XML node");
        }

        /*
        public static bool XMLNodeBoolean(XmlNode node, string name, bool defaultValue)
        {
            XmlNode child;
            child = node[name];
            if (child != null)
                return Convert.ToInt32(child.InnerText) != 0;
            return defaultValue;
        }
         * */

        #endregion

        #region Error handlers
        public static void LogException(Java.Lang.Throwable t)
        {
            Log.Error(Consts.Tag, t, "Exception caught:");
        }
        #endregion

        #region User login / update routines
        public static string CallWebServiceToLoginAndGetUserData(Activity context, string email, string password)
        {
#if NO_SERVER_HACK
            //This fake-up represents an internet call to login and have returned an XML string
            //containing a user id & name, current synced timesheet entries and clients
            //See if we have a valid user
            if ((email.Equals("brian@blong.com", StringComparison.InvariantCultureIgnoreCase) && (password == "password")) ||
                (email.Equals("john@blong.com",  StringComparison.InvariantCultureIgnoreCase) && (password == "password")))
            {
                string dataFileName = email.ToLower() + ".xml";
                //Have we written a copy of the asset out as a private file yet?
                if (context.FileList().Contains(dataFileName))
                {   //If so, read it in now                
                    var input = new InputStreamInvoker(context.OpenFileInput(dataFileName));
                    using (StreamReader sr = new StreamReader(input))
                        return sr.ReadToEnd();
                }
                else if (context.Assets.List("").Contains(dataFileName))
                {   //If not, read the asset file                
                    var input = context.Assets.Open(dataFileName);
                    using (StreamReader sr = new StreamReader(input))
                        return sr.ReadToEnd();
                }
            }
#endif
            return null;
        }

        public static void CallWebServiceToSendUserUpdatedEntries(Activity context, string email, string password, string newEntriesXml)
        {
            //To send updated we must have logged in, so we'll skip further user validation here
            string dataFileName = email.ToLower() + ".xml";
            string previousUserDataXml = null;
#if NO_SERVER_HACK
            //Have we written a copy of the asset out as a private file yet?
            if (context.FileList().Contains(dataFileName))
            {   //If so, read it in now                
                using (FileInputStream inputFile = context.OpenFileInput(dataFileName))
                {
                    using (InputStreamInvoker inputStream = new InputStreamInvoker(inputFile))
                    {
                        using (StreamReader sr = new StreamReader(inputStream))
                            previousUserDataXml = sr.ReadToEnd();
                    }
                }
            }
            else if (context.Assets.List("").Contains(dataFileName))
            {   //If not, read the asset file                

                using (Stream inputStream = context.Assets.Open(dataFileName))
                {
                    using (StreamReader sr = new StreamReader(inputStream))
                        previousUserDataXml = sr.ReadToEnd();
                }
            }
            //Now we have the XML string, we'll need to identify the 
            //<Entries>..</Entries> bit and slip the new data in there
            if ((previousUserDataXml ?? "") != "")
            {
                const string entriesEnd = "</Entries>";
                int entriesEndIdx;
                entriesEndIdx = previousUserDataXml.IndexOf(entriesEnd);
                string newUserDataXml = previousUserDataXml.Insert(entriesEndIdx, newEntriesXml);
                //Now write this new data out
                using (FileOutputStream outputFile = context.OpenFileOutput(dataFileName, FileCreationMode.Private))
                {
                    using (OutputStreamInvoker outputStream = new OutputStreamInvoker(outputFile))
                    {
                        using (StreamWriter sw = new StreamWriter(outputStream))
                            sw.Write(newUserDataXml);
                    }
                }
            }
#endif
        }

        public static void ProcessUserData(Activity context, string xmlString, bool newUser, string userEmail, string userPassword)
        {
            XmlDocument doc = new XmlDocument();
            doc.LoadXml(xmlString);
            XmlNode userNode = doc.SelectSingleNode("LoginResponse/User");
            if (userNode == null)
                throw new ArgumentException(context.GetString(Resource.String.LoginBadUserXML));

            XmlNode clientsNode = doc.SelectSingleNode("LoginResponse/Clients");
            if (clientsNode == null)
                throw new ArgumentException(context.GetString(Resource.String.LoginBadClientsXML));

            XmlNode entriesNode = doc.SelectSingleNode("LoginResponse/Entries");
            if (entriesNode == null)
                throw new ArgumentException(context.GetString(Resource.String.LoginBadEntriesXML));

            DBHelper helper = ((TimeSheetApplication)context.Application).DatabaseHelper;
            
            if (newUser)
            {
                //Set up new current user and put user details in the global preferences
                TimeSheetPreferences prefs = new TimeSheetPreferences(context.ApplicationContext);
                User user = User.FromXML(userNode);
                prefs.UserEmail = userEmail;
                prefs.UserPassword = userPassword;
                prefs.UserID = user.ID;
                Log.Info(Consts.Tag, "Setting user ID to : " + user.ID.ToString());
                prefs.UserName = user.Name;
                //Don't forget to commit those changes!
                prefs.Save();
                //Update local DB with the new data for this user from the 'server'
                helper.ResetUser(user);
            }

            //Set up new client list
            var clients = new List<Client>();
            foreach (XmlNode node in clientsNode.ChildNodes)
                clients.Add(Client.FromXML(node));

            //Set up user's timesheet entry list
            var entries = new List<Entry>();
            foreach (XmlNode node in entriesNode.ChildNodes)
                entries.Add(Entry.FromXML(node));

            //Update local DB with the new data for this user from the 'server'
            helper.ResetClients(clients);
            helper.ResetEntries(entries);
        }
        #endregion
    }
}