SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

ALTER PROCEDURE dbo.dns_GenerateValuations 
@ThisClientID INT, @ThisClientAddressType VARCHAR(50), 
@AdjustedStartValuationDate VARCHAR(10), @AdjustedEndValuationDate VARCHAR(10), 
@StartDate VARCHAR(10), @EndDate VARCHAR(10), @DateThreeMonthsAgo VARCHAR(10), 
@DateOneYearAgo VARCHAR(10),@DateThreeYearsAgo VARCHAR(10)
AS
--/Create Table tmpClients and populate
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpClients')
   DROP TABLE tmpClients

SELECT 
c.client_id,
c.client_name,
c.notes,
c.hostcode,
c.reportingname,
ca.address_line_1,
ca.address_line_2,
ca.address_line_3,
ca.address_line_4,
ca.city,
ca.post_code,
ca.telephone_number,
ca.fax_number,
p.portfolio_name,
p.reportingname AS PortfolioReportingName,
ps.PeriodEndDate,
ps.PeriodStartDate
INTO dbo.tmpClients
FROM clients c
LEFT OUTER JOIN client_addresses ca ON c.client_ID = ca.client_ID
LEFT OUTER JOIN portfolios p ON c.client_ID = p.primaryclientreference
JOIN ClientReportGroupClient crgp ON crgp.ClientReference = c.client_id
JOIN ClientReportGroup crg ON crgp.ReportGroupReference = crg.ReportGroupReference
JOIN PackSchedule ps ON ps.ReportGroupReference = crg.ReportGroupReference
WHERE ca.address_description = 'MAIN'
AND c.client_ID = @ThisClientID

--/Now create table tmpPortfolioSummary and populate
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpPortfolioSummary')
   DROP TABLE tmpPortfolioSummary

SELECT 
vl.portfolio_name, CAST(SUM(local_total_value) AS DECIMAL(18,2)) AS TotalValue, CAST(SUM(forecast_income) AS DECIMAL(18,2)) AS ForecastIncome, 
CAST(SUM(forecast_income) * 100 / SUM(local_total_value) AS DECIMAL(18,2)) AS Dividend_Yield,
0 AS LastMarketValue
INTO dbo.tmpPortfolioSummary
FROM valuations_library vl
JOIN portfolios p ON p.portfolio_id = vl.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
WHERE c.client_id = @ThisClientID
AND CONVERT(varchar(15), vl.valuation_date, 103) = @AdjustedEndValuationDate
GROUP BY vl.portfolio_name

UNION

SELECT vl.portfolio_name, 0, 0, 0,
CAST(SUM(local_total_value) AS DECIMAL(18,2))
FROM valuations_library vl
JOIN portfolios p ON p.portfolio_id = vl.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
WHERE c.client_id = @ThisClientID
AND CONVERT(varchar(15), vl.valuation_date + 1, 103) = @AdjustedStartValuationDate
GROUP BY vl.portfolio_name


--/Now create table tmpAssetAllocationbyAssetType and populate
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpAssetAllocationbyAssetType')
   DROP TABLE tmpAssetAllocationbyAssetType

SELECT t.asset_allocation_name, sum(t.AssetValue) AS AssetValue
INTO tmpAssetAllocationbyAssetType
FROM
(
SELECT al.asset_allocation_name, CAST(SUM(vl.valuation_capital) AS DECIMAL (18,2)) AS AssetValue
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
LEFT JOIN instruments i ON i.instrument_id = vl.asset_instrument_id
JOIN asset_allocations al ON i.underlying_asset_allocation_id = al.asset_allocation_id
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
--/AND al.asset_allocation_name <> 'Cash'
AND vl.asset_type = 'Security'
AND c.client_id = @ThisClientID
GROUP BY al.asset_allocation_name
UNION
SELECT al.asset_allocation_name, CAST(SUM(vl.valuation_capital) AS DECIMAL (18,2)) AS AssetValue
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
LEFT JOIN instruments i ON i.instrument_id = vl.asset_instrument_id
JOIN asset_allocations al ON 5 = al.asset_allocation_id
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
AND c.client_id = @ThisClientID
AND vl.asset_type = 'Cash'
GROUP BY al.asset_allocation_name



) AS t
GROUP BY t.asset_allocation_name


--/Now create the table tmpAssetAllocationByGeographicArea and populate
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpAssetAllocationByGeographicArea')
   DROP TABLE tmpAssetAllocationByGeographicArea

SELECT t.geographic_area_name, SUM(t.AssetValue) AS AssetValue
INTO tmpAssetAllocationByGeographicArea
FROM
(
SELECT ga.geographic_area_name, CAST(SUM(vl.valuation_capital) AS DECIMAL (18,2)) AS AssetValue
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
LEFT JOIN instruments i ON i.instrument_id = vl.asset_instrument_id
LEFT JOIN countries con ON i.country_id = con.country_id
JOIN geographic_areas ga ON con.geographic_area_id = ga.geographic_area_id
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
AND vl.asset_type = 'Security'
AND c.client_id = @ThisClientID
GROUP BY ga.geographic_area_name
UNION
SELECT ga.geographic_area_name, CAST(SUM(vl.valuation_capital) AS DECIMAL (18,2)) AS AssetValue
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
LEFT JOIN instruments i ON i.instrument_id = vl.asset_instrument_id
JOIN geographic_areas ga ON 23 = ga.geographic_area_id
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
AND vl.asset_type = 'Cash'
AND c.client_id = @ThisClientID
GROUP BY ga.geographic_area_name
)
AS t
GROUP BY t.geographic_area_name
ORDER By t.geographic_area_name


--/Now create the table tmpAssetAllocationByTopTen and populate
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpAssetAllocationByTopTen')
   DROP TABLE tmpAssetAllocationByTopTen


SELECT TOP 10 dbo.GetInstrumentName(i.hostcode) AS InstrumentName,
CAST(
SUM(vl.valuation_capital) / (SELECT SUM(vl.valuation_capital)
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
AND c.client_id = @ThisClientID ) AS DECIMAL(6,3)) AS AssetPercentage
INTO tmpAssetAllocationByTopTen
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
LEFT JOIN instruments i ON i.instrument_id = vl.asset_instrument_id
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
AND vl.asset_type = 'Security'
AND c.client_id = @ThisClientID
--/Ignore Iceberg and AimStic as holdings
AND i.instrument_id NOT IN (212,3163) 
GROUP BY dbo.GetInstrumentName(i.hostcode)
ORDER BY 2 DESC


--/Now create the table tmpConsolidatedPortfolioValuation and populate
--/This was modified on 01/02/08 to add in cash accounts
--/and assumes that the valuation_capital is the local currency value of whatever type of account it is
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpConsolidatedPortfolioValuation')
   DROP TABLE tmpConsolidatedPortfolioValuation

SELECT al.asset_allocation_name,ga.geographic_area_name, ig.industry_group_name,dbo.GetInstrumentName(i.hostcode) AS InstrumentName, 
CAST(vl.valuation_capital AS DECIMAL (18,2)) AS Marketvalue,
vl.local_currency_iso_code AS ISO_Code
INTO tmpConsolidatedPortfolioValuation
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
LEFT JOIN instruments i ON i.instrument_id = vl.asset_instrument_id
LEFT JOIN industry_sectors ise ON ise.industry_sector_id = i.industry_sector_id
LEFT JOIN industry_groups ig ON ig.industry_group_id = ise.industry_group_id
LEFT JOIN countries con ON i.country_id = con.country_id
JOIN geographic_areas ga ON con.geographic_area_id = ga.geographic_area_id
JOIN asset_allocations al ON i.underlying_asset_allocation_id = al.asset_allocation_id
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
AND c.client_id = @ThisClientID

UNION

SELECT 'Cash','United Kingdom', 'Cash', asset_name, 
CAST(vl.valuation_capital AS DECIMAL (18,2)) AS Marketvalue,
vl.local_currency_iso_code AS ISO_Code
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
WHERE vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
AND c.client_id = @ThisClientID
AND vl.asset_type = 'Cash'


--/Now create the table tmpPortfolioValuationAnalysis and populate
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpPortfolioValuationAnalysis')
   DROP TABLE tmpPortfolioValuationAnalysis

SELECT vl.portfolio_name,
	vl.valuation_date,
	vl.local_currency_name,
	vl.valuation_currency_name,
	vl.portfolio_type_name,
	Replace(vl.asset_name, ' -','') AS asset_name,
	vl.asset_type,
	vl.asset_currency_id,
	vl.exchange_rate,
	vl.price,
	vl.local_bookcost,
	vl.local_capital,
	vl.valuation_capital,
	vl.local_total_value,
	vl.local_gain_loss,
	vl.dividend_yield,
	vl.position_amount
INTO tmpPortfolioValuationAnalysis
FROM valuations_library vl
LEFT JOIN portfolios p ON vl.portfolio_id = p.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
WHERE 
c.client_id = @ThisClientID

AND
vl.valuation_date = CONVERT(DateTime,@AdjustedEndValuationDate,103)
ORDER BY vl.asset_name


--/Now create the table tmpOpeningBankBalances
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpOpeningBankBalances')
   DROP TABLE tmpOpeningBankBalances

SELECT ps.portfolio_name, ats.account_name, Min(CONVERT(DateTime,@StartDate,103)) AS StartDate, Max(CONVERT(DateTime,@EndDate,103)) AS EndDate, 
CAST(SUM(ct.amount * ct.sign_of_movement) AS DECIMAL(18,2)) AS opening_balance 
INTO tmpOpeningBankBalances
FROM cash_transactions ct
RIGHT JOIN assets ass ON ct.asset_id = ass.asset_id
JOIN accounts ats ON ass.account_id = ats.account_id
JOIN portfolios ps ON ats.portfolio_id = ps.portfolio_id
WHERE ass.asset_id IN
(

SELECT a.asset_id FROM assets a
JOIN accounts acc
ON a.account_id = acc.account_id
JOIN portfolios p
ON p.portfolio_id = acc.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
WHERE a.account_id IN
(SELECT account_id FROM accounts
WHERE portfolio_id IN
(SELECT portfolio_id FROM portfolios
WHERE c.client_id = @ThisClientID)
)
AND ass.asset_type = 'Cash'
)
AND
(

ct.value_date <=  CONVERT(DateTime,@StartDate,103)
)
GROUP BY ps.portfolio_name, ats.account_name


--/This tries to create bank account statements from one date to another
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpBankStatement')
   DROP TABLE tmpBankStatement

SELECT ps.portfolio_name, ats.account_name, ct.value_date, ct.amount, ct.sign_of_movement,
ct.narrative 
INTO tmpBankStatement
FROM cash_transactions ct
RIGHT JOIN assets ass ON ct.asset_id = ass.asset_id
JOIN accounts ats ON ass.account_id = ats.account_id
JOIN portfolios ps ON ats.portfolio_id = ps.portfolio_id
WHERE ass.asset_id IN
(
SELECT a.asset_id FROM assets a
JOIN accounts acc
ON a.account_id = acc.account_id
JOIN portfolios p
ON p.portfolio_id = acc.portfolio_id
JOIN clients c ON c.client_id = p.primaryclientreference
WHERE a.account_id IN
(SELECT account_id FROM accounts
WHERE portfolio_id IN
(SELECT portfolio_id FROM portfolios
WHERE c.client_id = @ThisClientID)
)
AND ass.asset_type = 'Cash'
)
AND
(
ct.value_date > CONVERT(DateTime, @StartDate, 103)
AND 
ct.value_date <= CONVERT(DateTime, @EndDate, 103)
AND ct.transaction_status_id <> 6
AND ct.transaction_status_id <> 0
)
ORDER BY ps.portfolio_name, ats.account_name, ct.value_date asc

--/Now create the sales and purchase transactions table 
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpSalePurchaseTransactions')
   DROP TABLE tmpSalePurchaseTransactions

SELECT 
REPLACE(assets.asset_name,' -','') AS asset_name,
st.nominal_amount,
st.trade_date,
st.value_date,
st.price,
st.consideration,
st.commissions,
st.other_charges,
st.bookcost,
st.proceeds,
st.profit_loss,
st.sign_of_movement,
st.narrative,
st.TaxableProfitLoss,
tt.transaction_type_name,
portfolios.portfolio_name,
pt.portfolio_type_name,
portfolios.ReportingName AS PortfolioReportingName,
clients.client_name,
clients.reportingName AS ClientReportingName,
currencies.currency_ISO_Code
INTO tmpSalePurchaseTransactions
FROM security_transactions st
JOIN transaction_types tt on tt.transaction_type_id = st.transaction_type_id
JOIN assets ON assets.asset_id = st.asset_id
JOIN accounts on accounts.account_id = assets.account_id
JOIN portfolios on portfolios.portfolio_id = accounts.portfolio_id
JOIN portfolio_types pt ON portfolios.portfolio_type_id = pt.portfolio_type_id
JOIN clients on clients.client_id = portfolios.primaryclientreference
JOIN currencies on currencies.currency_id = st.deal_currency_id
WHERE assets.asset_id IN
(SELECT asset_id FROM assets WHERE account_id IN
(
SELECT account_id FROM accounts WHERE portfolio_id IN 
(SELECT portfolio_id FROM portfolios 
JOIN Clients ON portfolios.primaryclientreference = clients.client_id 
WHERE clients.client_id  = @ThisClientID)
))
--/rest of the outer where statement here
AND (st.trade_date >= Convert(datetime,@StartDate,103)) 
AND (st.trade_date < Convert(datetime,@EndDate,103))
AND ((tt.transaction_Type_Name = 'Sale') OR (tt.transaction_Type_Name = 'Purchase') OR (tt.transaction_Type_Name = 'C/Sale') OR (tt.transaction_Type_Name = 'C/Purchase'))
AND (st.transaction_status_id <> 6)
order by trade_date desc


--/Now get the other transactions such as Reorganisations etc
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpOtherTransactions')
   DROP TABLE tmpOtherTransactions

SELECT 
assets.asset_name,
st.nominal_amount,
st.trade_date,
st.value_date,
st.price,

st.consideration,
st.commissions,
st.other_charges,
st.bookcost,
st.proceeds,
st.profit_loss,
st.sign_of_movement,
st.narrative,
st.TaxableProfitLoss,
tt.transaction_type_name,
portfolios.portfolio_name,
pt.portfolio_type_name,
portfolios.ReportingName AS PortfolioReportingName,
clients.client_name,
clients.reportingName AS ClientReportingName,
currencies.currency_ISO_Code,
b.broker_name
INTO tmpOtherTransactions
FROM security_transactions st
JOIN transaction_types tt on tt.transaction_type_id = st.transaction_type_id
JOIN assets ON assets.asset_id = st.asset_id
JOIN accounts on accounts.account_id = assets.account_id
JOIN portfolios on portfolios.portfolio_id = accounts.portfolio_id
JOIN portfolio_types pt ON portfolios.portfolio_type_id = pt.portfolio_type_id
JOIN clients on clients.client_id = portfolios.primaryclientreference
JOIN currencies on currencies.currency_id = st.deal_currency_id
JOIN brokers b ON b.broker_id = st.broker_id
WHERE assets.asset_id IN
(SELECT asset_id FROM assets WHERE account_id IN
(
SELECT account_id FROM accounts WHERE portfolio_id IN 
(SELECT portfolio_id FROM portfolios 
JOIN Clients ON portfolios.primaryclientreference = clients.client_id 
WHERE clients.client_id  = @ThisClientID)
))
--/rest of the outer where statement here
AND (st.trade_date >= Convert(datetime,@StartDate,103)) 
AND (st.trade_date < Convert(datetime,@EndDate,103))
AND ((tt.transaction_Type_Name <> 'Sale') AND (tt.transaction_Type_Name <> 'Purchase') AND (tt.transaction_Type_Name <> 'C/Sale') AND (tt.transaction_Type_Name <> 'C/Purchase'))
AND (st.transaction_status_id <> 6)
order by trade_date desc

--/Now for the dreaded KYC

IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpKYC')
   DROP TABLE tmpKYC


SELECT 
@ThisClientID AS Client_ID,
(SELECT ct.Client_type_name FROM client_types ct JOIN clients c ON c.client_type_id = ct.client_type_id WHERE c.client_id = @ThisClientID) AS Organisation_Type,
(SELECT ct.IsOrganisation FROM client_types ct JOIN clients c ON c.client_type_id = ct.client_type_id WHERE c.client_id = @ThisClientID) AS Is_Organisation,
(SELECT prepared_to_pay_cgt FROM clients WHERE client_id = @ThisClientID) AS Vat_Payable,
(SELECT tax_rate FROM clients WHERE client_id = @ThisClientID) AS VAT_Rate,
(SELECT MAX(servicelevel) FROM portfolios p JOIN clients c ON c.client_id = p.primaryclientreference WHERE client_id = @ThisClientID) AS ServiceLevel,
(SELECT PrimaryAdvisor FROM dbo.dns_SwapBIFSAround ( @ThisClientID)) AS FundManagerName,
(SELECT SecondaryAdvisor FROM dbo.dns_SwapBIFSAround ( @ThisClientID)) AS SecondFundManagerName,
(SELECT MAX(b.benchmark_name) FROM clients c 
JOIN portfolios p ON c.client_id = p.primaryclientreference
JOIN benchmarks b ON p.benchmark_id = b.benchmark_id 
WHERE client_id = @ThisClientID) AS Benchmark,
(SELECT p.EMail FROM clients c JOIN personnel p ON c.PrimaryAdvisorReference = p.PersonnelReference WHERE c.client_id = @ThisClientID) AS FundManagerEmail,
(SELECT p.EMail FROM clients c JOIN personnel p ON c.SecondaryAdvisorReference = p.PersonnelReference WHERE c.client_id = @ThisClientID) AS SecondFundManagerEmail,
(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1PostCode,
(SELECT EMailAddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1AccountName,
(SELECT MobileNumber FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1SortCode,
(SELECT OfficeNumber FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK1') AS Bank1AccountNo,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2PostCode,
(SELECT EMailAddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2AccountName,
(SELECT MobileNumber FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2SortCode,
(SELECT OfficeNumber FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BANK2') AS Bank2AccountNo,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'ACCOUNTANT') AS AccountantName,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'ACCOUNTANT') AS AccountantAddr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'ACCOUNTANT') AS AccountantAddr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'ACCOUNTANT') AS AccountantAddr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'ACCOUNTANT') AS AccountantPostCode,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'IFA') AS IFAName,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'IFA') AS IFAAddr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'IFA') AS IFAAddr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'IFA') AS IFAAddr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'IFA') AS IFAPostCode,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BOND PROVIDER') AS BPName,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BOND PROVIDER') AS BPAddr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BOND PROVIDER') AS BPAddr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BOND PROVIDER') AS BPAddr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'BOND PROVIDER') AS BPPostCode,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SIPP PROVIDER') AS SPName,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SIPP PROVIDER') AS SPAddr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SIPP PROVIDER') AS SPAddr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SIPP PROVIDER') AS SPAddr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SIPP PROVIDER') AS SPPostCode,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SOLICITOR') AS SOLICITORName,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SOLICITOR') AS SOLICITORAddr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SOLICITOR') AS SOLICITORAddr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SOLICITOR') AS SOLICITORAddr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'SOLICITOR') AS SOLICITORPostCode,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_1') AS TRUSTEE_1_Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_1') AS TRUSTEE_1_Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_1') AS TRUSTEE_1_Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_1') AS TRUSTEE_1_Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_1') AS TRUSTEE_1_PostCode,
(SELECT telephone_number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_1') AS TRUSTEE_1_TelNo,
(SELECT Emailaddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_1') AS TRUSTEE_1_EMail,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_2') AS TRUSTEE_2_Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_2') AS TRUSTEE_2_Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_2') AS TRUSTEE_2_Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_2') AS TRUSTEE_2_Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_2') AS TRUSTEE_2_PostCode,
(SELECT telephone_number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_2') AS TRUSTEE_2_TelNo,
(SELECT Emailaddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_2') AS TRUSTEE_2_EMail,

(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_3') AS TRUSTEE_3_Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_3') AS TRUSTEE_3_Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_3') AS TRUSTEE_3_Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_3') AS TRUSTEE_3_Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_3') AS TRUSTEE_3_PostCode,
(SELECT telephone_number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_3') AS TRUSTEE_3_TelNo,
(SELECT Emailaddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_3') AS TRUSTEE_3_EMail,


(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_4') AS TRUSTEE_4_Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_4') AS TRUSTEE_4_Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_4') AS TRUSTEE_4_Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_4') AS TRUSTEE_4_Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_4') AS TRUSTEE_4_PostCode,
(SELECT telephone_number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_4') AS TRUSTEE_4_TelNo,
(SELECT Emailaddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_4') AS TRUSTEE_4_EMail,



(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_5') AS TRUSTEE_5_Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_5') AS TRUSTEE_5_Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_5') AS TRUSTEE_5_Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_5') AS TRUSTEE_5_Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_5') AS TRUSTEE_5_PostCode,
(SELECT telephone_number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_5') AS TRUSTEE_5_TelNo,
(SELECT Emailaddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_5') AS TRUSTEE_5_EMail,



(SELECT address_line_1 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_6') AS TRUSTEE_6_Name,
(SELECT address_line_2 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_6') AS TRUSTEE_6_Addr1,
(SELECT address_line_3 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_6') AS TRUSTEE_6_Addr2,
(SELECT address_line_4 FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_6') AS TRUSTEE_6_Addr3,
(SELECT post_code FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_6') AS TRUSTEE_6_PostCode,
(SELECT telephone_number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_6') AS TRUSTEE_6_TelNo,
(SELECT Emailaddress FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'TRUSTEE_6') AS TRUSTEE_6_EMail,

(SELECT telephone_Number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'MAIN') AS MainTelNo,
(SELECT fax_Number FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'MAIN') AS MainFAXNo,
(SELECT OfficeNumber FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'MAIN') AS OfficeTelNo,
(SELECT MobileNumber FROM client_addresses WHERE client_id = @ThisClientID AND address_description = 'MAIN') AS MobileTelNo,
(SELECT date_of_birth FROM clients WHERE client_id = @ThisClientID) AS MainClientDOB,
(SELECT marital_status FROM clients WHERE client_id = @ThisClientID) AS MaritalStatus,
(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 47) AS PartnerName,

(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 9) AS Charity_Number,


(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 25) AS Tax_Office_Number,

(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 52) AS Partners_DOB,

(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 13) AS NI_Number,

--/Now find the primary info
(SELECT TextValue FROM dbo.KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 2 
AND 	AttributeReference = 17) AS PrimaryInfo,


--/now find the principle objectives
(SELECT Caption FROM KYCAttributeOption
WHERE AttributeOptionReference IN
(
SELECT AttributeOptionReference FROM KYCEntityOptionHistory JOIN
(
SELECT entityhistoryreference FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 3 
AND 	AttributeReference = 1) X
ON X.EntityHistoryReference = KYCEntityOptionHistory.EntityHistoryReference
WHERE Checked = 1
)
AND     AreaReference = 3 
AND 	AttributeReference = 1)  AS PrincipleObjective,


--/now find the risk profile
(SELECT Caption FROM KYCAttributeOption
WHERE AttributeOptionReference IN
(
SELECT AttributeOptionReference FROM KYCEntityOptionHistory JOIN
(
SELECT entityhistoryreference FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 3 
AND 	AttributeReference = 2) X
ON X.EntityHistoryReference = KYCEntityOptionHistory.EntityHistoryReference
WHERE Checked = 1
)
AND     AreaReference = 3 
AND 	AttributeReference = 2) AS RiskProfile,

--/Now select the first client e-mail address	
(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 61) AS FirstClientEMail,

--/Now select the second client e-mail address	
(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 51) AS SecondClientEMail,


--/Now for the charity number
(SELECT NumericValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 2
AND AttributeReference = 9) AS CharityNumber,


--/Now for the Schedule Information and Number
(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 3
AND AttributeReference = 9)  AS ScheduleNumber,

(SELECT TextValue FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND AreaReference = 3
AND AttributeReference = 11) AS ScheduleFrequency,


--/Now for the Income Instruction
(SELECT Caption FROM KYCAttributeOption
WHERE AttributeOptionReference IN
(
SELECT AttributeOptionReference FROM KYCEntityOptionHistory JOIN
(
SELECT entityhistoryreference FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 5 
AND 	AttributeReference = 5) X
ON X.EntityHistoryReference = KYCEntityOptionHistory.EntityHistoryReference
WHERE Checked = 1
)
AND     AreaReference = 5 
AND 	AttributeReference = 5)  AS IncomeInstruction,



(SELECT Caption FROM KYCAttributeOption
WHERE AttributeOptionReference IN
(
SELECT AttributeOptionReference FROM KYCEntityOptionHistory JOIN
(
SELECT entityhistoryreference FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 3 
AND 	AttributeReference = 5) X
ON X.EntityHistoryReference = KYCEntityOptionHistory.EntityHistoryReference
WHERE Checked = 1
)
AND     AreaReference = 3 
AND 	AttributeReference = 5) AS ValuationDate1, 

(
--/Now for valuation date2
SELECT Caption FROM KYCAttributeOption
WHERE AttributeOptionReference IN
(
SELECT AttributeOptionReference FROM KYCEntityOptionHistory JOIN
(
SELECT entityhistoryreference FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 3 
AND 	AttributeReference = 6) X
ON X.EntityHistoryReference = KYCEntityOptionHistory.EntityHistoryReference
WHERE Checked = 1
)
AND     AreaReference = 3 
AND 	AttributeReference = 6
) AS ValuationDate2,

--/Now for valuation date3
(SELECT Caption AS ValuationDate3 FROM KYCAttributeOption
WHERE AttributeOptionReference IN
(
SELECT AttributeOptionReference FROM KYCEntityOptionHistory JOIN
(
SELECT entityhistoryreference FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 3 
AND 	AttributeReference = 7) X
ON X.EntityHistoryReference = KYCEntityOptionHistory.EntityHistoryReference
WHERE Checked = 1
)
AND     AreaReference = 3 
AND 	AttributeReference = 7) AS ValuationDate3,


--/Now for valuation date4
(SELECT Caption AS ValuationDate4 FROM KYCAttributeOption
WHERE AttributeOptionReference IN
(
SELECT AttributeOptionReference FROM KYCEntityOptionHistory JOIN
(
SELECT entityhistoryreference FROM KYCEntityHistory 
WHERE 
	EntityReference = 
(
SELECT EntityReference FROM dbo.KYCEntity WHERE  ClientReference = @ThisClientID
)
AND	AreaReference = 3 
AND 	AttributeReference = 8) X
ON X.EntityHistoryReference = KYCEntityOptionHistory.EntityHistoryReference
WHERE Checked = 1
)
AND     AreaReference = 3 
AND 	AttributeReference = 8) AS ValuationDate4

INTO tmpKYC



--/Now get the report recipients address details
IF EXISTS(SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES
      WHERE TABLE_NAME = 'tmpRecipientAddress')
   DROP TABLE tmpRecipientAddress


SELECT * 
INTO tmpRecipientAddress
FROM client_addresses
WHERE client_id = @ThisClientID AND address_description = @ThisClientAddressType













GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

